IF OBJECT_ID('P_EXP_CTB_MOV_DOACAO') IS NOT NULL
	BEGIN
		DROP PROCEDURE P_EXP_CTB_MOV_DOACAO
	END
 
GO
 
CREATE PROCEDURE P_EXP_CTB_MOV_DOACAO( @CD_EMP		INT,
									   @CD_FILIAL	INT,
									   @DT_INI		DATETIME,
									   @DT_FIM		DATETIME,
									   @FLAG_LIMPAR INT = 0)		
	

WITH ENCRYPTION AS  
SET NOCOUNT ON;
BEGIN TRY
BEGIN
	
	DECLARE @RS_CD_EMP				INT
	DECLARE @RS_CD_FILIAL			INT 		
	DECLARE @RS_DT_CUPOM			DATETIME
	DECLARE @RS_CD_ENTID			INT					
	DECLARE @RS_NM_ENTID			VARCHAR(100)
	DECLARE @RS_CD_CTB_CNT			VARCHAR(100)
	DECLARE @RS_CD_CTB_CNT_RED		INT
	DECLARE @RS_VLR_DINHEIRO		MONEY
	DECLARE @RS_VLR_CARTAO			MONEY
	DECLARE @NR_CONTROLE            VARCHAR(20)
	DECLARE @RS_CD_CLI				INT

	DECLARE @RET_CD_CTB_CNT_RED		INT 
	DECLARE @RET_CD_CTB_CNT		    VARCHAR(100)	 

	------------------------------------------------------------------------------------------------------------------------------
	--CRIANDO A TABELA TEMPORARIA ##CTB_EXP_MOV
	------------------------------------------------------------------------------------------------------------------------------
	EXEC P_EXP_CTB_MOV_CRIAR_CTB_EXP_MOV @FLAG_LIMPAR	
   
	DECLARE RS_RESULT
	CURSOR FOR 	
		SELECT
			CD_EMP,
			CD_FILIAL,
			DT_CUPOM,
			CD_ENTID,
			NM_ENTID,
			CD_CTB_CNT,
			CD_CTB_CNT_RED,
		    VLR_DINHEIRO,
		    VLR_CARTAO,
			CD_CLI
	       FROM UFD_EXP_CTB_MOV_DOACAO(@CD_EMP, @CD_FILIAL, @DT_INI, @DT_FIM)
		  
        ORDER BY  CD_EMP, CD_FILIAL, DT_CUPOM


		--Abrindo cursor
		OPEN RS_RESULT
		
		--Atribuindo valores do select nas variveis
		FETCH NEXT FROM RS_RESULT INTO 
					@RS_CD_EMP,
					@RS_CD_FILIAL,
					@RS_DT_CUPOM,
					@RS_CD_ENTID,
					@RS_NM_ENTID,
					@RS_CD_CTB_CNT,
					@RS_CD_CTB_CNT_RED,
					@RS_VLR_DINHEIRO,
					@RS_VLR_CARTAO,
					@RS_CD_CLI					
					 

		--Iniciando lao
		WHILE @@FETCH_STATUS = 0
			BEGIN	
			
				------------------------------------------------------------------------------------------------------------------
				--DOACAO DEBITO - Ctb_Cnt_Caixa
				------------------------------------------------------------------------------------------------------------------
			IF  @RS_VLR_DINHEIRO > 0  
			   BEGIN

				SET @NR_CONTROLE = RIGHT('0000'+CAST(@RS_CD_FILIAL AS VARCHAR(4)),4) +  
								RIGHT('00'+ CAST( DAY( @RS_DT_CUPOM) AS VARCHAR),2) + 
								 RIGHT('00'+  CAST( MONTH(@RS_DT_CUPOM) AS VARCHAR),2) + 
								  RIGHT('0000'+ CAST( YEAR(@RS_DT_CUPOM)AS VARCHAR),4) + 
								  RIGHT('0000000'+ CAST(@RS_CD_ENTID AS VARCHAR(7)),7)
								   

				INSERT INTO ##CTB_EXP_MOV  

						  (CD_EMP,CD_FILIAL_EXPORT, CD_FILIAL,  CD_MOVIMENTO, MOVIMENTO, OPERACAO, OPERACAO_DEBITO,
						  CD_CNT_RED_CREDITO, CD_CNT_CREDITO, CD_CNT_RED_DEBITO, CD_CNT_DEBITO, DT_MOV, HIST,
						  VLR_LANC, TP_TRANSA, RATEIO_CENTRO_CUSTO, DS_CENTRO_CUSTO, CNT_CENTRO_CUSTO, VLR_CENTRO_CUSTO,
						  ORIG_CONTA, COD_CONTA,NM_PROCEDURE,TIPO_LANCTO, CD_EVENTO, NR_DP, ANO, NR_DOC, CD_BC_LANC)

					SELECT		@RS_CD_EMP							AS CD_EMP,
								@CD_FILIAL							AS CD_FILIAL_EXPORT,
								@RS_CD_FILIAL						AS CD_FILIAL,
								9									AS CD_MOVIMENTO,
								'DOACAO DE VENDAS'					AS MOVIMENTO,
								''									AS OPERACAO,
								'LANCTO DOACAO DE VENDAS DINHEIRO - DEBITO'	AS OPERACAO_DEBITO,
								0									AS CD_CNT_RED_CREDITO,
								''									AS CD_CNT_CREDITO,
								0									AS CD_CNT_RED_DEBITO,
								''									AS CD_CNT_DEBITO,
								@RS_DT_CUPOM						AS DT_MOV,
								'REBCTO DOACAO PROGRAMA TROCO FACIL ENTIDADE.: ' + Left(@RS_NM_ENTID, 25) + ' FILIAL.: ' + RIGHT('000' + CAST(@RS_CD_FILIAL AS VARCHAR), 3) AS HIST,
								ROUND(@RS_VLR_DINHEIRO,2)			AS VLR_LANC,
								'D'									AS TP_TRANSA,
								0									AS RATEIO_CENTRO_CUSTO,
								''									AS DS_CENTRO_CUSTO,
								0									AS CNT_CENTRO_CUSTO,
								0									AS VLR_CENTRO_CUSTO,
								'FILIAIS'							AS ORIG_CONTA,
								0									AS COD_CONTA,
								OBJECT_NAME(@@PROCID)				AS NM_PROCEDURE
								, 'T' AS TIPO_LANCTO
                                        , 0 AS CD_EVENTO
										, 0  AS NR_DP
										, 0  AS ANO
										,@NR_CONTROLE AS NR_DOC
										, '' AS CD_BC_LANC;	

				------------------------------------------------------------------------------------------------------------------
				--DOACAO CREDITO - CONTAS DAS ENTIDADES
				------------------------------------------------------------------------------------------------------------------
				INSERT INTO ##CTB_EXP_MOV 
				
						  (CD_EMP,CD_FILIAL_EXPORT, CD_FILIAL,  CD_MOVIMENTO, MOVIMENTO, OPERACAO, OPERACAO_DEBITO,
						  CD_CNT_RED_CREDITO, CD_CNT_CREDITO, CD_CNT_RED_DEBITO, CD_CNT_DEBITO, DT_MOV, HIST,
						  VLR_LANC, TP_TRANSA, RATEIO_CENTRO_CUSTO, DS_CENTRO_CUSTO, CNT_CENTRO_CUSTO, VLR_CENTRO_CUSTO,
						  ORIG_CONTA, COD_CONTA,NM_PROCEDURE,TIPO_LANCTO, CD_EVENTO, NR_DP, ANO, NR_DOC, CD_BC_LANC) 

					SELECT		@RS_CD_EMP							AS CD_EMP,
								@CD_FILIAL							AS CD_FILIAL_EXPORT,
								@RS_CD_FILIAL						AS CD_FILIAL,
								9									AS CD_MOVIMENTO,
								'DOACAO DE VENDAS'					AS MOVIMENTO,
								'LANCTO DOACAO DE VENDAS DINHEIRO - CREDITO'	AS OPERACAO,
								''									AS OPERACAO_DEBITO,
								@RS_CD_CTB_CNT_RED					AS CD_CNT_RED_CREDITO,
								@RS_CD_CTB_CNT						AS CD_CNT_CREDITO,
								0									AS CD_CNT_RED_DEBITO,
								''									AS CD_CNT_DEBITO,
								@RS_DT_CUPOM						AS DT_MOV,
								'REBCTO DOACAO PROGRAMA TROCO FACIL ENTIDADE.: ' + Left(@RS_NM_ENTID, 25) + ' FILIAL.: ' + RIGHT('000' + CAST(@RS_CD_FILIAL AS VARCHAR), 3) AS HIST,
								ROUND(@RS_VLR_DINHEIRO,2)			AS VLR_LANC,
								'C'									AS TP_TRANSA,
								0									AS RATEIO_CENTRO_CUSTO,
								''									AS DS_CENTRO_CUSTO,
								0									AS CNT_CENTRO_CUSTO,
								0									AS VLR_CENTRO_CUSTO,
								''						            AS ORIG_CONTA,
								0						            AS COD_CONTA,
								OBJECT_NAME(@@PROCID)				AS NM_PROCEDURE                                        
								, 'T' AS TIPO_LANCTO
                                        , 0 AS CD_EVENTO
										, 0  AS NR_DP
										, 0  AS ANO
										,@NR_CONTROLE AS NR_DOC
										, '' AS CD_BC_LANC;	
			END							
												
				IF @RS_VLR_CARTAO > 0
				 
				 BEGIN

				  				SET @NR_CONTROLE = RIGHT('0000'+CAST(@RS_CD_FILIAL AS VARCHAR(4)),4) +  
								RIGHT('00'+ CAST( DAY( @RS_DT_CUPOM) AS VARCHAR),2) + 
								 RIGHT('00'+  CAST( MONTH(@RS_DT_CUPOM) AS VARCHAR),2) + 
								  RIGHT('0000'+ CAST( YEAR(@RS_DT_CUPOM)AS VARCHAR),4) + 
								  RIGHT('0000000'+ CAST(@RS_CD_ENTID AS VARCHAR(7)),7)

			       SELECT @RET_CD_CTB_CNT_RED = CLI_CTB.CD_CTB_CNT_RED
                         , @RET_CD_CTB_CNT = CLI_CTB.CD_CTB_CNT
                         
                    FROM  RC_CLI INNER JOIN RC_CLI_CNT_CTB CLI_CTB ON 
					       RC_CLI.CD_EMP =  CLI_CTB.CD_EMP
						   AND RC_CLI.CD_CLI =  CLI_CTB.CD_CLI 
					      WHERE TP_CNT_CTB = 0 AND CLI_CTB.CD_CLI  =  @RS_CD_CLI;

				INSERT INTO ##CTB_EXP_MOV  

						  (CD_EMP,CD_FILIAL_EXPORT, CD_FILIAL,  CD_MOVIMENTO, MOVIMENTO, OPERACAO, OPERACAO_DEBITO,
						  CD_CNT_RED_CREDITO, CD_CNT_CREDITO, CD_CNT_RED_DEBITO, CD_CNT_DEBITO, DT_MOV, HIST,
						  VLR_LANC, TP_TRANSA, RATEIO_CENTRO_CUSTO, DS_CENTRO_CUSTO, CNT_CENTRO_CUSTO, VLR_CENTRO_CUSTO,
						  ORIG_CONTA, COD_CONTA,NM_PROCEDURE,TIPO_LANCTO, CD_EVENTO, NR_DP, ANO, NR_DOC, CD_BC_LANC)

					SELECT		@RS_CD_EMP							AS CD_EMP,
								@CD_FILIAL							AS CD_FILIAL_EXPORT,
								@RS_CD_FILIAL						AS CD_FILIAL,
								9									AS CD_MOVIMENTO,
								'DOACAO DE VENDAS'					AS MOVIMENTO,
								''									AS OPERACAO,
								'LANCTO DOACAO DE VENDAS CARTAO - DEBITO'	AS OPERACAO_DEBITO,
								0				                   AS CD_CNT_RED_CREDITO,
								''					               AS CD_CNT_CREDITO,
								@RET_CD_CTB_CNT_RED				   AS CD_CNT_RED_DEBITO,
								@RET_CD_CTB_CNT					   AS CD_CNT_DEBITO,
								@RS_DT_CUPOM					   AS DT_MOV,
								'REBCTO DOACAO PROGRAMA TROCO FACIL ENTIDADE.: ' + Left(@RS_NM_ENTID, 25) + ' FILIAL.: ' + RIGHT('000' + CAST(@RS_CD_FILIAL AS VARCHAR), 3) AS HIST,
								ROUND(@RS_VLR_CARTAO,2)			AS VLR_LANC,
								'D'									AS TP_TRANSA,
								0									AS RATEIO_CENTRO_CUSTO,
								''									AS DS_CENTRO_CUSTO,
								0									AS CNT_CENTRO_CUSTO,
								0									AS VLR_CENTRO_CUSTO,
								''							        AS ORIG_CONTA,
								0        						    AS COD_CONTA,
								-- ver como encontrar @RS_CD_CLI  na P_EXP_CTB_MOV_VENDAS_CONTABIL_CARTAO
								OBJECT_NAME(@@PROCID)				AS NM_PROCEDURE
								, 'T' AS TIPO_LANCTO
                                        , 0 AS CD_EVENTO
										, 0  AS NR_DP
										, 0  AS ANO
										,@NR_CONTROLE AS NR_DOC
										, '' AS CD_BC_LANC;	

				------------------------------------------------------------------------------------------------------------------
				--DOACAO CREDITO - CONTAS DAS ENTIDADES
				------------------------------------------------------------------------------------------------------------------
				INSERT INTO ##CTB_EXP_MOV
				
						  (CD_EMP,CD_FILIAL_EXPORT, CD_FILIAL,  CD_MOVIMENTO, MOVIMENTO, OPERACAO, OPERACAO_DEBITO,
						  CD_CNT_RED_CREDITO, CD_CNT_CREDITO, CD_CNT_RED_DEBITO, CD_CNT_DEBITO, DT_MOV, HIST,
						  VLR_LANC, TP_TRANSA, RATEIO_CENTRO_CUSTO, DS_CENTRO_CUSTO, CNT_CENTRO_CUSTO, VLR_CENTRO_CUSTO,
						  ORIG_CONTA, COD_CONTA,NM_PROCEDURE,TIPO_LANCTO, CD_EVENTO, NR_DP, ANO, NR_DOC, CD_BC_LANC) 

					SELECT		@RS_CD_EMP							AS CD_EMP,
								@CD_FILIAL							AS CD_FILIAL_EXPORT,
								@RS_CD_FILIAL						AS CD_FILIAL,
								9									AS CD_MOVIMENTO,
								'DOACAO DE VENDAS'					AS MOVIMENTO,
								'LANCTO DOACAO DE VENDAS CARTAO - CREDITO'	AS OPERACAO,
								''									AS OPERACAO_DEBITO,
								@RS_CD_CTB_CNT_RED					AS CD_CNT_RED_CREDITO,
								@RS_CD_CTB_CNT						AS CD_CNT_CREDITO,
								0									AS CD_CNT_RED_DEBITO,
								''									AS CD_CNT_DEBITO,
								@RS_DT_CUPOM						AS DT_MOV,
								'REBCTO DOACAO PROGRAMA TROCO FACIL ENTIDADE.: ' + Left(@RS_NM_ENTID, 25) + ' FILIAL.: ' + RIGHT('000' + CAST(@RS_CD_FILIAL AS VARCHAR), 3) AS HIST,
								ROUND(@RS_VLR_CARTAO,2)			AS VLR_LANC,
								'C'									AS TP_TRANSA,
								0									AS RATEIO_CENTRO_CUSTO,
								''									AS DS_CENTRO_CUSTO,
								0									AS CNT_CENTRO_CUSTO,
								0									AS VLR_CENTRO_CUSTO,
								'ENTID DOACAO'						AS ORIG_CONTA,
								@RS_CD_ENTID						AS COD_CONTA,
								OBJECT_NAME(@@PROCID)				AS NM_PROCEDURE                                        
								, 'T' AS TIPO_LANCTO
                                        , 0 AS CD_EVENTO
										, 0  AS NR_DP
										, 0  AS ANO
										,@NR_CONTROLE AS NR_DOC
										, '' AS CD_BC_LANC;	
						END		 
				------------------------------------------------------------------------------------------------------------------
				--Prximo registro				
				------------------------------------------------------------------------------------------------------------------
				FETCH NEXT FROM RS_RESULT INTO 
						@RS_CD_EMP,
						@RS_CD_FILIAL,
						@RS_DT_CUPOM,
						@RS_CD_ENTID,
						@RS_NM_ENTID,
						@RS_CD_CTB_CNT,
						@RS_CD_CTB_CNT_RED,
						@RS_VLR_DINHEIRO,
						@RS_VLR_CARTAO,
						@RS_CD_CLI																		

			END
		
		CLOSE RS_RESULT
		DEALLOCATE RS_RESULT	
END

END TRY
BEGIN CATCH
	CLOSE RS_RESULT
	DEALLOCATE RS_RESULT	

	INSERT INTO ADM_ERRO (numero, severidade, estado, rotina, linha, mensagem, dtErro)
		SELECT
			ERROR_NUMBER() AS numero,
			ERROR_SEVERITY() AS severidade,
			ERROR_STATE() AS estado,
			ERROR_PROCEDURE() AS rotina,
			ERROR_LINE() AS linha,
			ERROR_MESSAGE() AS mensagem,
			GETDATE() AS dtErro;	
END CATCH					
  